/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1;

import com.roguewave.chart.core.v2_1.ChartBuilder;
import com.roguewave.chart.core.v2_1.ChartGraphics;
import com.roguewave.chart.core.v2_1.ChartProperties;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.events.DataUpdateEvent;
import com.roguewave.chart.core.v2_1.events.DataUpdateListener;
import com.roguewave.chart.core.v2_1.graphics.BufferedCanvas3D;
import com.roguewave.chart.datamodels.v2_1.SampleData;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ChartLite
extends BufferedCanvas3D
implements DataUpdateListener {
    protected ChartProperties properties_;
    private ChartBuilder builder_;
    private DataModel data_;
    private ChartGraphics graphics_;
    private boolean busy_ = false;
    private boolean queued_ = false;
    protected boolean updatesSuspended_ = false;

    protected ChartLite() {
        this.properties_ = new ChartProperties();
        this.properties_.setChartHeight(this.getPreferredSize().height - 75);
        this.builder_ = null;
        this.data_ = new SampleData();
        this.data_.addDataUpdateListener(this);
        this.setBackground(Color.white);
    }

    public ChartLite(ChartBuilder builder, DataModel data) {
        this(builder, data, new ChartProperties());
    }

    public ChartLite(ChartBuilder builder, DataModel data, ChartProperties properties) {
        this.properties_ = properties;
        this.builder_ = builder;
        this.data_ = data;
        this.data_.addDataUpdateListener(this);
        this.graphics_ = this.builder_.build(this.properties_, this.data_);
        this.graphics_.add2DTo(this);
        this.setBackground(Color.white);
    }

    protected void setBuilder(ChartBuilder builder) {
        this.builder_ = builder;
        this.graphics_ = this.builder_.build(this.properties_, this.data_);
        this.graphics_.add2DTo(this);
    }

    public DataModel getData() {
        return this.data_;
    }

    public void setData(DataModel data) {
        this.data_.removeDataUpdateListener(this);
        this.data_ = data;
        this.data_.addDataUpdateListener(this);
        this.update();
    }

    public void setChartHeight(double height) {
        this.properties_.setChartHeight(height);
        this.update();
    }

    public boolean suspendUpdates(boolean flag) {
        boolean save = this.updatesSuspended_;
        this.updatesSuspended_ = flag;
        return save;
    }

    public synchronized void update() {
        if (this.busy_ || this.updatesSuspended_) {
            this.queued_ = true;
            return;
        }
        this.busy_ = true;
        this.queued_ = false;
        this.clear();
        this.graphics_ = this.builder_.build(this.properties_, this.data_);
        this.graphics_.add2DTo(this);
        this.repaint();
    }

    public synchronized void update(Graphics g) {
        super.update(g);
        this.busy_ = false;
        if (this.queued_) {
            this.update();
        }
    }

    public void dataUpdate(DataUpdateEvent updateEvent) {
        this.update();
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (size.width == 0 || size.height == 0) {
            return new Dimension(300, 250);
        }
        return size;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.update();
    }
}

